/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.compat.modmenu;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.fabricmc.loader.api.FabricLoader;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.modmenu.ModMenuConfig;

public final class ModMenuManager {
    private static ModMenuConfig config;
    private static final Path configPath;
    private static final Gson GSON;
    private static final Executor EXECUTOR;

    private ModMenuManager() {
    }

    public static ModMenuConfig getConfig() {
        return config != null ? config : ModMenuManager.init();
    }

    private static ModMenuConfig init() {
        if (!Files.exists(configPath, new LinkOption[0])) {
            ModMenuManager.save().join();
        }
        ((CompletableFuture)ModMenuManager.load().thenApply(o -> {
            config = o;
            return config;
        })).join();
        return Objects.requireNonNull(config, "Failed to init config");
    }

    private static CompletableFuture<ModMenuConfig> load() {
        return CompletableFuture.supplyAsync(() -> {
            ModMenuConfig modMenuConfig;
            block8: {
                BufferedReader reader = Files.newBufferedReader(configPath);
                try {
                    modMenuConfig = (ModMenuConfig)GSON.fromJson((Reader)reader, ModMenuConfig.class);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException e) {
                        ResourceChickens.LOGGER.error("Unable to read config file, restoring defaults!", e);
                        ModMenuManager.save();
                        return new ModMenuConfig();
                    }
                }
                reader.close();
            }
            return modMenuConfig;
        }, EXECUTOR);
    }

    public static CompletableFuture<Void> save() {
        return CompletableFuture.runAsync(() -> {
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                GSON.toJson((Object)Optional.ofNullable(config).orElseGet(ModMenuConfig::new), (Appendable)writer);
            }
            catch (JsonIOException | IOException e) {
                ResourceChickens.LOGGER.error("Unable to write config file", e);
            }
        }, EXECUTOR);
    }

    static {
        configPath = FabricLoader.getInstance().getConfigDir().resolve("resourcechickens.json");
        GSON = new GsonBuilder().setPrettyPrinting().create();
        EXECUTOR = Executors.newSingleThreadExecutor(r -> new Thread(r, "Resource Chickens Config Manager"));
    }
}

